% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractRegion.R
\name{extractRegion}
\alias{extractRegion}
\title{\code{extractRegion}}
\usage{
extractRegion(
  SampleTileObj,
  region,
  cellPopulations = "ALL",
  groupColumn = NULL,
  subGroups = NULL,
  sampleSpecific = FALSE,
  approxLimit = 1e+05,
  binSize = 250,
  numCores = 1,
  verbose = FALSE
)
}
\arguments{
\item{SampleTileObj}{The SummarizedExperiment object output from getSampleTileMatrix}

\item{region}{a GRanges object or vector or strings containing the regions on which to compute co-accessible links. Strings must be in the format "chr:start-end", e.g. "chr4:1300-2222".}

\item{cellPopulations}{vector of strings. Cell subsets for which to call
peaks. This list of group names must be identical to names that appear in
the SampleTileObj.  Optional, if cellPopulations='ALL', then peak
calling is done on all cell populations. Default is 'ALL'.}

\item{groupColumn}{Optional, the column containing sample group labels for returning coverage within sample groups. Default is NULL, all samples will be used.}

\item{subGroups}{a list of subgroup(s) within the groupColumn from the metadata. Optional, default is NULL, all labels within groupColumn will be used.}

\item{sampleSpecific}{If TRUE, get a sample-specific count dataframe out. Default is FALSE, average across samples and get a dataframe out.}

\item{approxLimit}{Optional limit to region size, where if region is larger than approxLimit basepairs, binning will be used. Default is 100000.}

\item{binSize}{Optional, size of bins in basepairs when binning is used. Default is 250.}

\item{numCores}{integer. Number of cores to parallelize peak-calling across
multiple cell populations}

\item{verbose}{Set TRUE to display additional messages. Default is FALSE.}
}
\value{
countSE a SummarizedExperiment containing coverage for the given input cell populations.
}
\description{
\code{extractRegion} will extract the coverage files created
  by callOpenTiles and return a specific region's coverage
}
\examples{
\dontrun{
countSE <- MOCHA::extractRegion(
  SampleTileObj = SampleTileMatrices,
  cellPopulations = "ALL",
  region = "chr1:18137866-38139912",
  numCores = 30,
  sampleSpecific = FALSE
)
}

}
