% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPopFrags.R
\name{getPopFrags}
\alias{getPopFrags}
\title{Extract fragments by populations from an ArchR Project}
\usage{
getPopFrags(
  ArchRProj,
  cellPopLabel,
  cellSubsets = "ALL",
  poolSamples = FALSE,
  numCores = 1,
  verbose = FALSE
)
}
\arguments{
\item{ArchRProj}{The ArchR Project.}

\item{cellPopLabel}{The name of the metadata column of the ArchR Project that contains the populations
of cells you want to extract fragments from.}

\item{cellSubsets}{Default is 'ALL'. If you want to export only some populations,
then give it a list of group names. This needs to be unique - no duplicated
names. This list of group names must be identical to names that appear in
the given cellPopLabel metadata column of the ArchR Project.}

\item{poolSamples}{Set TRUE to pool sample-specific fragments by cell population. By default this is FALSE and sample-specific fragments are returned.}

\item{numCores}{Number of cores to use.}

\item{verbose}{Set TRUE to display additional messages. Default is FALSE.}
}
\value{
A list of GRanges containing fragments. Each GRanges corresponds to a
  population defined by cellSubsets and sample.
}
\description{
\code{getPopFrags} returns a list of sample-specific fragments per cell population as a GRangesList.
}
