% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportCoverage.R
\name{exportMotifs}
\alias{exportMotifs}
\title{\code{exportMotifs}}
\usage{
exportMotifs(
  SampleTileObject,
  motifsGRanges,
  motifSetName = "motifs",
  filterByOpenTiles = FALSE,
  outDir,
  verbose = FALSE
)
}
\arguments{
\item{SampleTileObject}{The SummarizedExperiment object output from
\code{getSampleTileMatrix}}

\item{motifsGRanges}{A GRanges containing motif annotations, typically from
\code{addMotifSet(returnSTM=FALSE)}}

\item{motifSetName}{Optional, a name indicating the motif set. Used to name
files in the specified \code{outdir}. Default is "motifs".}

\item{filterByOpenTiles}{Boolean. If TRUE, a bigBed file will be exported
for each cell population with motifs filtered to those occurring
only in open tiles.}

\item{outDir}{Desired output directory where bigBed files will be saved}

\item{verbose}{Set TRUE to display additional messages. Default is FALSE.}
}
\value{
outList A List of output filepaths
}
\description{
\code{exportMotifs} exports a motif set GRanges from running
   \code{addMotifSet(returnSTM=FALSE)} to bigBed file files for visualization
   in genome browsers.
}
\examples{
\dontrun{
MOCHA::exportMotifs(
  SampleTileObject = SampleTileMatrices,
  motifsGRanges,
  motifSetName = "CISBP",
  filterByOpenTiles = FALSE,
  outDir = tempdir(),
  verbose = TRUE
)
}

}
