% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergeTileResults.R
\name{mergeTileResults}
\alias{mergeTileResults}
\title{\code{mergeTileResults}}
\usage{
mergeTileResults(tileResultsList, numCores = 1, verbose = TRUE)
}
\arguments{
\item{tileResultsList}{List of MultiAssayExperiments objects returned by
callOpenTiles containing containing peak calling results.}

\item{numCores}{Optional, the number of cores to use with multiprocessing.
Default is 1.}

\item{verbose}{Set TRUE to display additional messages. Default is FALSE.}
}
\value{
tileResults a single MultiAssayExperiment containing a sample-tile
  intensity matrix for each sample and common cell population in the input
  tileResultsList.
}
\description{
\code{mergeTileResults} merges a list of tileResults that
  each contain unique samples into a single object encompassing all samples.
  Only cell populations shared among all input tileResults will be retained.
  This function can merge MultiAssayExperiment objects from callOpenTiles
  that are created with the same TxDb, OrgDb, and Genome assembly.
}
\examples{
\dontrun{
# Depends on local MOCHA tileResults
MOCHA::mergeTileResults(
  list(tileResultsCelltypesABC, tileResultsCelltypesBCD)
)
}

}
