% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varZIGLMM.R
\name{varZIGLMM}
\alias{varZIGLMM}
\title{Zero-inflated Variance Decomposition for pseudobulked scATAC data}
\usage{
varZIGLMM(
  TSAM_Object,
  cellPopulation = NULL,
  continuousRandom = NULL,
  ziRandom = NULL,
  zi_threshold = 0.1,
  verbose = FALSE,
  numCores = 1
)
}
\arguments{
\item{TSAM_Object}{A SummarizedExperiment object generated from
getSampleTileMatrix.}

\item{cellPopulation}{Name of a cell type(s), or 'all'. The function will
combine the cell types mentioned into one matrix before running the model.}

\item{continuousRandom}{Random effects to test in the continuous portion. All
factors must be found in column names of the TSAM_Object metadata, except
for FragNumber and CellCount, which will be extracted from the
TSAM_Object's metadata.}

\item{ziRandom}{Random effects to test in the zero-inflated portion. All
factors must be found in column names of the TSAM_Object colData metadata,
except for FragNumber and CellCount, which will be extracted from the
TSAM_Object's metadata.}

\item{zi_threshold}{Zero-inflated threshold ( range = 0-1), representing the
fraction of samples with zeros. When the percentage of zeros in the tile is
between 0 and zi_threshold, samples with zeroes are dropped and only the
continous formula is used. Use this parameter at your own risk. Default is
0.}

\item{verbose}{Set TRUE to display additional messages. Default is FALSE.}

\item{numCores}{integer. Number of cores to parallelize across.}
}
\value{
results a SummarizedExperiment containing results from ZIGLMM (Fixed
  effect estiamtes, P-values, and Std Error)
}
\description{
`r lifecycle::badge("deprecated")`
  This function is deprecated - improved modeling functions can be found in 
  the package "ChAI" at https://github.com/aifimmunology/ChAI
  \code{varZIGLMM} Identified variance decomposition on a given
  cell type across both zero-inflated and continuous space using a
  zero-inflated general linear mixed model \code{\link[glmmTMB]{glmmTMB}}
}
\examples{
\dontrun{
modelList <- runZIGLMM(STM[c(1:1000), ],
  cellPopulation = "CD16 Mono",
  continuousRandom = c("Age", "Sex", "Days"),
  ziRandom = c("FragNumber", "Days"),
  verbose = TRUE,
  numCores = 35
)
}

}
