% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_bandind_matrix.R
\name{set_bandind_matrix}
\alias{set_bandind_matrix}
\title{Helper function to determine the bands needed to compute SIs and QIs}
\usage{
set_bandind_matrix(
  bandnames,
  bandsel,
  indexes_bandnames,
  indexes_bandsel,
  indexes_formula,
  quality_bandnames,
  quality_bandsel,
  quality_source
)
}
\arguments{
\item{bandnames}{names of all layers available for the product being processed}

\item{bandsel}{\verb{character array} Original MODIS layers to be processed.
You can get a list of available layers for a given product
using function \code{MODIStsp_get_prodlayers} (e.g., MODIStsp_get_prodlayers("M*D13Q1")$bandnames),
Default: NULL}

\item{indexes_bandnames}{names of all indexes available for the product being processed}

\item{indexes_bandsel}{\verb{character array}Spectral Indexes to be computed starting from reflectance bands.
You can get a list of available quality layers for a given product
using function \code{MODIStsp_get_prodlayers} (e.g., MODIStsp_get_prodlayers("M*D13Q1")$indexes_bandnames),
Default: NULL}

\item{indexes_formula}{formulas of all indexes available for the product being processed}

\item{quality_bandnames}{names of all quality indicators available for the product being processed}

\item{quality_bandsel}{\verb{character array} Quality Indicators to be computed starting from
bit fields of original MODIS layers. You can get a list of available quality layers for a given product
using function \code{MODIStsp_get_prodlayers} (e.g., MODIStsp_get_prodlayers("M*D13Q1")$quality_bandnames),
Default: NULL}

\item{quality_source}{sources of data (original layers) of all quality indicators
available for the product being processed}
}
\value{
\code{matrix} containing info on which bands are needed for computing
each available QI or SI
}
\description{
FUNCTION_DESCRIPTION
}
\author{
Lorenzo Busetto, phD (2017)
}
