% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.r
\docType{data}
\name{abdat}
\alias{abdat}
\title{abdat A list of fishery data for blacklip abalone}
\format{
A data.frame of three columns
\describe{
  \item{year}{the annual year in which the catches occurred}
  \item{catch}{the reported landed catch in tonnes, to the nearest kilogram}
  \item{cpue}{the standardized catch-per-unit-effort for this dive fishery}
}
}
\source{
Catch data from Mundy, C. and J. McAllister (2019) Tasmanian abalone fishery assessment 2018, Institute for Marine and Antarctic Studies, University of Tasmania, 190p. ISBN: 978-1-925646-46-7. The cpue data is an unpublished early attempt at standardizing the cpue data with respect to month, block, and diver. Many more details are now included in such analyses.
}
\description{
A dataset of fishery data for blacklip abalone 
    (\emph{Haliotis rubra}) from part of the Tasmanian west coast 
    for the years 1985 - 2008. It contains a data.frame containing
    the year, the catch, and the standardized CPUE from four 
    statistical blocks of Tasmania's west coast combined. In 
    particular, it can be used when fitting a surplus production 
    model. Workable initial parameter values, before log-transformation 
    might be: r= 0.4, K=9400, Binit=3400, sigma=0.05 for the 
    Schaefer version, while these also work for the Fox model 
    one could more efficiently use r=0.3, K=12000, Binit=4000, sigma=0.05.
}
\section{Subjects}{

 \itemize{
  \item Surplus Production Modelling, Schaefer and Fox models
  \item Model fitting using maximum likelihood
  \item Uncertainty examples
 }
}

\examples{
 data(abdat)
 print(abdat)
 oldpar <- par(no.readonly=TRUE)
 plot(abdat$year,abdat$cpue, type="l",xlab="year",ylab="CPUE",
      panel.first=grid())
 points(abdat$year,abdat$cpue,pch=16,cex=1.2)
 par(oldpar)
}
