% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spm.r
\name{getlag}
\alias{getlag}
\title{getlag is used to look for the response of cpue to previous catches}
\usage{
getlag(fish, maxlag = 10, plotout = TRUE, indexI = 1)
}
\arguments{
\item{fish}{the matrix or data.frame containing the fishery data 
(year, catch, and cpue)}

\item{maxlag}{the lag.max parameter for the ccf function; defaults to 10}

\item{plotout}{should a plot be made; default=TRUE. If FALSE then, 
assuming the result of the analysis is put into an object called
'ans' a call to plot(ans) will generate the required plot.}

\item{indexI}{if there are more than one time-series of cpue/indices then
this parameter selects which to use}
}
\value{
an object of class acf, which can be plotted
}
\description{
getlag is a wrapper for the ccf function (cross correlation)
    that is used within the spm analyses to determine at what
    negative lag, if any, cpue data is informative about the stock 
    dynamics beyond any information already available in the catch data.
    If the cpue is directly correlated with catches (lag=0 has a strong
    correlation) then cpue will not add much more information to an 
    analysis. Only if there is a significant negative correlation is it 
    likely that the cpue will increase the information available and 
    make it more likely that an assessment model may be able to be fitted 
    meaningfully to the available data. If there is no significant 
    negative correlations then it becomes much more unlikely that a 
    useful model fit to the cpue will be possible. The getlag function 
    first finds those rows for which both catch and cpue have values 
    and then it runs the cross-correlation analysis. Thus, you cannot 
    have gaps in your cpue data although there can be catches at the 
    start or end of the time-series, or both, for which there are no 
    cpue data.
}
\examples{
year <- 1985:2008
catch <- c(1018,742,868,715,585,532,566,611,548,499,479,428,657,481,
           645,961,940,912,955,935,940,952,1030,985)
cpue <- c(0.6008,0.6583,0.6791,0.6889,0.7134,0.7221,0.7602,0.7931,0.8582,
          0.8876,1.0126,1.1533,1.2326,1.2764,1.3307,1.3538,1.2648,1.2510,
          1.2069,1.1552,1.1238,1.1281,1.1113,1.0377)
dat <- as.data.frame(cbind(year,catch,cpue))
out <- getlag(dat,plotout=FALSE)
plot(out,lwd=3,col=2)
str(out)
}
