% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fisheries.r
\name{logist}
\alias{logist}
\title{logist Logistic selectivity function}
\usage{
logist(inL50, delta, depend, knifeedge = FALSE)
}
\arguments{
\item{inL50}{is the length at 50 percent selection/maturity/whatever}

\item{delta}{is the difference in selection/maturity/whatever between
inL50 and inL95}

\item{depend}{a vector of lengths/ages for which the logistic value
will be calculated.}

\item{knifeedge}{defaults to FALSE. If knifeedge is TRUE then the
logistic values < the depend value of inL50 is set to
zero, and all those >= inL50 are set to 1.0, approximating
knife-edge selectivity}
}
\value{
A vector of length(depend) with the predicted logistic values
}
\description{
logist calculates a Logistic curve that can be used as a
    selectivity function, or maturity curve, of wherever a logistic 
    is required. This version uses the logistic function
    1/(1+exp(-log(19.0)*(lens-inL50)/delta)), which
    explicitly defines the L50 and uses delta = (inL95-inL50) as
    the second parameter.
}
\examples{
in50 <- 100.0
deltaS <- 8.0
lens <- seq(2,210,2)
select <- logist(inL50=in50,delta=deltaS,depend=lens)
selectk <- logist(in50,deltaS,lens,knifeedge=TRUE)
round(cbind(lens[35:70],select[35:70],selectk[35:70]),5)
}
