% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MMSE_plots.R
\name{plot.MMSE}
\alias{plot.MMSE}
\alias{plot,MMSE,missing-method}
\title{Standard plot for an object of class MMSE (multi MSE)}
\usage{
\S4method{plot}{MMSE,missing}(
  x,
  maxcol = 6,
  qcol = rgb(0.4, 0.8, 0.95),
  lcol = "dodgerblue4",
  quants = c(0.05, 0.25, 0.75, 0.95),
  curyr = 2018,
  addline = FALSE
)
}
\arguments{
\item{x}{Object of class \linkS4class{MMSE}. A Multi-OM object created by \code{multiMSE(MOM, ...)}}

\item{maxcol}{Integer. The maximum number of columns (MPs) to be plotted in each plot}

\item{qcol}{Character, color. The color of the inner percentile range}

\item{lcol}{Character, color. The color of the outer percentile range.}

\item{quants}{Numeric vector. The percentiles that are plotted (LB2,LB1,UB1,UB2). LB2 and UB2 are the outer percentiles, LB1 and UB1 are the inner percentiles.}

\item{curyr}{Integer. The current year from which projections start.}

\item{addline}{Logical. Should two individual simulations be added to the percentile plots?}
}
\description{
Plot the projected biomass, fishing, mortality rate and yield for all stocks and MPs
}
\author{
T.Carruthers
}
