% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSmix_functions_package.R
\name{confintMSmix}
\alias{confintMSmix}
\title{Hessian-based confidence intervals for mixtures of Mallows models with Spearman distance}
\usage{
confintMSmix(
  n_items,
  sample_size,
  theta_mle,
  weights_mle = (if (length(theta_mle) == 1) NULL),
  z_hat = (if (length(theta_mle) == 1) NULL),
  conf_level = 0.95
)
}
\arguments{
\item{n_items}{Number of items.}

\item{sample_size}{Number of rankings in the observed sample.}

\item{theta_mle}{Numeric vector with the MLEs of the \eqn{G} component-specific precision parameters.}

\item{weights_mle}{Numeric vector with the MLEs of the \eqn{G} mixture weights.}

\item{z_hat}{Numeric \eqn{N}\eqn{\times}{x}\eqn{G} matrix of the estimated component membership probabilities. This coincides with the object \code{z_hat} returned by \code{fitMSmix}, needed when \code{n_clust > 1}.}

\item{conf_level}{Value in the interval (0,1) indicating the desired confidence level of the interval estimates. Defaults to 0.95.}
}
\value{
A list with the following named components:

\item{\code{ci_theta}}{The confidence intervals for the precision parameters.}
\item{\code{ci_weights}}{The confidence intervals for the mixture weights. Returned when \eqn{G>1}.}
}
\description{
Return the Hessian-based confidence intervals of the continuous parameters of a mixture of Mallow models with Spearman distance, namely the component-specific precisions and weights.
}
\examples{

## Example 1. Simulate rankings from a 2-component mixture of Mallow models with Spearman distance.
set.seed(123)
d_sim <- rMSmix(sample_size = 75, n_items = 8, n_clust = 2)
str(d_sim)
# Fit the true model.
rankings <- d_sim$samples
set.seed(123)
fit <- fitMSmix(rankings = rankings, n_clust = 2, n_start = 10)
# Compute the hessian-based confidence intervals for the MLEs of the weights and precisions.
confintMSmix(n_items = ncol(rankings), sample_size = nrow(rankings),
                theta_mle = fit$mod$theta, weights_mle = fit$mod$weights,
                z_hat = fit$mod$z_hat)

}
\references{
Crispino M, Mollica C, Modugno L, Casadio Tarabusi E, and Tardella L (2024+). MSmix: An R Package for clustering partial rankings via mixtures of Mallows Models with Spearman distance. \emph{(submitted)}

Marden JI (1995). Analyzing and modeling rank data. \emph{Monographs on Statistics and Applied Probability} (64). Chapman & Hall, ISSN: 0-412-99521-2. London.

Mclachlan G and Peel D (2000). Finite Mixture Models. \emph{Vol. 299. New York: Wiley}.
}
