% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSmix_functions_package.R
\name{confintMSmix}
\alias{confintMSmix}
\alias{print.ciMSmix}
\title{Asymptotic confidence intervals for the fitted mixture of Mallows models with Spearman distance}
\usage{
confintMSmix(object, conf_level = 0.95)

\method{print}{ciMSmix}(x, ...)
}
\arguments{
\item{object}{An object of class \code{"emMSmix"} returned by \code{\link{fitMSmix}}.}

\item{conf_level}{Numeric: value in the interval (0,1] indicating the desired confidence level of the interval estimates. Defaults to 0.95.}

\item{x}{An object of class \code{"ciMSmix"} returned by \code{\link{confintMSmix}}.}

\item{...}{Further arguments passed to or from other methods (not used).}
}
\value{
An object of class \code{"ciMSmix"}, namely a list with the following named components:
\describe{
\item{\code{ci_theta}}{Numeric \eqn{G}\eqn{\times}{x}\eqn{2} matrix with the confidence intervals of the component-specific precision parameters in each row.}
\item{\code{ci_weights}}{Numeric \eqn{G}\eqn{\times}{x}\eqn{2} matrix with the confidence intervals of the mixture weights in each row (when \eqn{G>1}), otherwise \code{NULL}.}
}
}
\description{
Return the asymptotic confidence intervals of the continuous parameters (component-specific precisions and weights) of a mixture of Mallows models with Spearman distance fitted to full rankings.

\code{print} method for class \code{"ciMSmix"}.
}
\details{
The current implementation of the asymptotic confidence intervals assumes that the observed rankings are complete.
}
\examples{

## Example 1. Simulate rankings from a 2-component mixture of Mallows models
## with Spearman distance.
set.seed(123)
d_sim <- rMSmix(sample_size = 75, n_items = 8, n_clust = 2)
rankings <- d_sim$samples
# Fit the basic Mallows model with Spearman distance.
set.seed(123)
fit1 <- fitMSmix(rankings = rankings, n_clust = 1, n_start = 10)
# Compute the asymptotic confidence intervals for the MLEs of the precision.
ci95_fit1 <- confintMSmix(object = fit1)
print(ci95_fit1)
# Fit the true model.
set.seed(123)
fit2 <- fitMSmix(rankings = rankings, n_clust = 2, n_start = 10)
# Compute the asymptotic confidence intervals for the MLEs of the weights and precisions.
ci95_fit2 <- confintMSmix(object = fit2)
print(ci95_fit2)

}
\references{
Crispino M, Mollica C and Modugno L (2025+). MSmix: An R Package for clustering partial rankings via mixtures of Mallows Models with Spearman distance. \emph{(submitted)}

Marden JI (1995). Analyzing and modeling rank data. \emph{Monographs on Statistics and Applied Probability} (64). Chapman & Hall, ISSN: 0-412-99521-2. London.

McLachlan G and Peel D (2000). Finite Mixture Models. \emph{Wiley Series in Probability and Statistics}, John Wiley & Sons.
}
