% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_mst.R
\name{plot_mst}
\alias{plot_mst}
\title{Plot Multiscalar Typology (3 deviations)}
\usage{
plot_mst(
  x,
  gdevrel,
  tdevrel,
  sdevrel,
  legend.lab = NULL,
  lib.var,
  lib.val,
  cex.lab = 1,
  cex.axis = 0.8,
  cex.names = 0.8
)
}
\arguments{
\item{x}{a sf object or a dataframe including 3 pre-calculated deviations.}

\item{gdevrel}{name of the general relative deviation variable in x.}

\item{tdevrel}{name of the territorial relative deviation variable in x.}

\item{sdevrel}{name of the the spatial relative deviation variable in x.}

\item{legend.lab}{label for explaining the plot (default = "G: general, 
T: territorial, S: spatial (relative deviations, average = 100)".}

\item{lib.var}{column name of x including territorial units name/code we
want to display on the plot.}

\item{lib.val}{a vector of territorial units included in lib.label we want
to display on the plot.}

\item{cex.lab}{size of the axis legend label text (default = 1).}

\item{cex.axis}{size of the tick label numbers (default = 0.8).}

\item{cex.names}{size of the territorial units labels if selected 
(default 0.8).}
}
\value{
A barplot displaying the position for selected territorial units
on three territorial deviation. Y axis is expressed in logarithm 
(25 % above the average corresponding to index 125 and 25 % below the average
being index 80).
}
\description{
Vizualizing mst for selected territorial units.
}
\examples{
# Load data
data("GrandParisMetropole")

# Prerequisite  - Compute the 3 relative deviations
com$gdev <- gdev(x = com, var1 = "INC", var2 = "TH")
com$tdev <- tdev(x = com, var1 = "INC", var2 = "TH", key = "EPT")
com$sdev <- sdev(x = com, var1 = "INC", var2 = "TH", order = 1)

# Synthesis barplot (3 territorial units)
plot_mst(x = com, gdevrel = "gdev", tdevrel = "tdev", sdevrel = "sdev", lib.var = "LIBCOM",
         lib.val = c("Neuilly-sur-Seine", "Clichy-sous-Bois", "Les Lilas"))
}
