% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{Normalize}
\alias{Normalize}
\title{Objective space normalization.}
\usage{
Normalize(objectiveValue, referencePoints = NULL)
}
\arguments{
\item{objectiveValue}{Set of objective vectors to normalize}

\item{referencePoints}{Set of reference points to transform following the objective vector normalization}
}
\value{
A list containing the following:
\code{normalizedObjective} The normalized values
\code{idealPoint} The ideal point corresponding to the origin
\code{transformedReference} The location of reference points in the normalized Space
}
\description{
Normalize the objectives AND reference (combined) to 0-1. The origin is the ideal point. (1,...,1) is the nadir.
}
\examples{
nObj <- 5
nVar <- 10
nIndividual <- 100
population <- InitializePopulationLHS(nIndividual,nVar,FALSE)
objective <- matrix(,nrow=nObj,ncol=nIndividual)
for(individual in 1:nIndividual){
   objective[,individual] <- WFG4(population[,individual],nObj)
}
Normalize(objective)
}
