% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tune.R
\name{tune}
\alias{tune}
\alias{tune.formula}
\alias{tune.ModelFrame}
\alias{tune.recipe}
\title{Model Tuning and Selection}
\usage{
tune(x, ...)

\method{tune}{formula}(x, data, models, grid = data.frame(),
  control = CVControl, metrics = NULL, stat = mean,
  maximize = TRUE, ...)

\method{tune}{ModelFrame}(x, models, grid = data.frame(),
  control = CVControl, metrics = NULL, stat = mean,
  maximize = TRUE, ...)

\method{tune}{recipe}(x, models, grid = data.frame(),
  control = CVControl, metrics = NULL, stat = mean,
  maximize = TRUE, ...)
}
\arguments{
\item{x}{defined relationship between model predictors and an outcome.  May
be a \code{ModelFrame} containing a formula, data, and optionally case
weights; a \code{formula}; or a \code{recipe.}}

\item{...}{arguments passed to the \code{metrics} functions.}

\item{data}{\code{data.frame} containing observed predictors and outcomes.}

\item{models}{\code{MLModel} constructor function or character string or a
list of \code{MLModel} contructors or objects.}

\item{grid}{\code{data.frame} containing parameter values over which to
evaluate \code{models} when a single constructor is specified.  Ignored in
the case of a list of models.}

\item{control}{\code{\link{MLControl}} object, control function, or character
string naming a control function defining the resampling method to be
employed.}

\item{metrics}{function, one or more function names, or list of named
functions to include in the calculation of performance metrics.  The default
\code{\link{modelmetrics}} are used unless otherwise specified.  Model
selection is based on the first specified metric.}

\item{stat}{function to compute a summary statistic on resampled values of
the metric for model selection.}

\item{maximize}{logical indicating whether to select the model having the
maximum or minimum value of the performance metric.}
}
\value{
\code{MLModelTune} class object that inherits from \code{MLModel}.
}
\description{
Evaluate a model over a grid of tuning parameters or a list of specified
model objects and select the best one according to resample estimation of
predictive performance.
}
\examples{
\donttest{
## Survival response example
library(MASS)

fo <- medv ~ .

(gbmtune <- tune(fo, data = Boston, model = GBMModel,
                 grid = expand.grid(n.trees = c(25, 50, 100),
                                    interaction.depth = 1:3,
                                    n.minobsinnode = c(5, 10)),
                 control = CVControl(folds = 10, repeats = 5)))
summary(gbmtune)
plot(gbmtune, type = "line")

gbmfit <- fit(fo, data = Boston, model = gbmtune)
varimp(gbmfit)
}

}
\seealso{
\code{\link{ModelFrame}}, \code{\link[recipes]{recipe}},
\code{\link{modelinfo}}, \code{\link{MLControl}}, \code{\link{fit}},
\code{\link{plot}}, \code{\link{summary}}
}
