% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recipe_roles.R
\name{recipe_roles}
\alias{recipe_roles}
\alias{role_binom}
\alias{role_case}
\alias{role_pred}
\alias{role_surv}
\title{Set Recipe Roles}
\usage{
role_binom(recipe, x, size)

role_case(recipe, stratum, weight, replace = FALSE)

role_pred(recipe, offset, replace = FALSE)

role_surv(recipe, time, event)
}
\arguments{
\item{recipe}{existing \link[recipes]{recipe} object.}

\item{x, size}{number of counts and trials for the specification of a
\code{\link{BinomialVariate}} outcome.}

\item{stratum}{variable for stratified \link[=resample]{resampling} of cases.}

\item{weight}{numeric variable of case weights for model
\link[=fit]{fitting}.}

\item{replace}{logical indicating whether to replace existing roles.}

\item{offset}{numeric variable to be added to a linear predictor, such as in
a generalized linear model, with known coefficient 1 rather than an
estimated coefficient.}

\item{time, event}{numeric follow up time and 0-1 numeric or logical event
indicator for specification of a \code{\link[survival]{Surv}} outcome.  If
the event indicator is omitted, all cases are assumed to have events.}
}
\value{
An updated recipe object.
}
\description{
Add to or replace the roles of variables in a preprocessing recipe.
}
\examples{
library(MASS)
library(recipes)

rec <- recipe(time + status ~ sex + age + year + thickness + ulcer,
              data = within(Melanoma, status <- status != 2)) \%>\%
  role_surv(time = time, event = status) \%>\%
  role_case(stratum = status)

(res <- resample(rec, model = CoxModel))
summary(res)

}
\seealso{
\code{\link[recipes]{recipe}}
}
