% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/response.R
\name{response}
\alias{response}
\alias{response.MLModelFit}
\alias{response.ModelFrame}
\alias{response.recipe}
\title{Extract Response Variable}
\usage{
response(object, ...)

\method{response}{MLModelFit}(object, newdata = NULL, ...)

\method{response}{ModelFrame}(object, newdata = NULL, ...)

\method{response}{recipe}(object, newdata = NULL, ...)
}
\arguments{
\item{object}{model \link{fit} result, \code{\link{ModelFrame}}, or
\code{\link[recipes]{recipe}}.}

\item{...}{arguments passed to other methods.}

\item{newdata}{\link[=data.frame]{data frame} from which to extract the
response variable values if given; otherwise, \code{object} is used.}
}
\description{
Extract the response variable from an object.
}
\examples{
## Survival response example
library(survival)

mf <- ModelFrame(Surv(time, status) ~ ., data = veteran)
response(mf)

}
