% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ML_GLMModel.R
\name{GLMModel}
\alias{GLMModel}
\alias{GLMStepAICModel}
\title{Generalized Linear Model}
\usage{
GLMModel(family = NULL, quasi = FALSE, ...)

GLMStepAICModel(
  family = NULL,
  quasi = FALSE,
  ...,
  direction = c("both", "backward", "forward"),
  scope = list(),
  k = 2,
  trace = FALSE,
  steps = 1000
)
}
\arguments{
\item{family}{optional error distribution and link function to be used in the
model.  Set automatically according to the class type of the response
variable.}

\item{quasi}{logical indicator for over-dispersion of binomial and Poisson
families; i.e., dispersion parameters not fixed at one.}

\item{...}{arguments passed to \code{\link[stats]{glm.control}}.}

\item{direction}{mode of stepwise search, can be one of \code{"both"}
(default), \code{"backward"}, or \code{"forward"}.}

\item{scope}{defines the range of models examined in the stepwise search.
This should be a list containing components \code{upper} and \code{lower},
both formulae.}

\item{k}{multiple of the number of degrees of freedom used for the penalty.
Only \code{k = 2} gives the genuine AIC; \code{k = .(log(nobs))} is
sometimes referred to as BIC or SBC.}

\item{trace}{if positive, information is printed during the running of
\code{stepAIC}. Larger values may give more information on the fitting
process.}

\item{steps}{maximum number of steps to be considered.}
}
\value{
\code{MLModel} class object.
}
\description{
Fits generalized linear models, specified by giving a symbolic description of
the linear predictor and a description of the error distribution.
}
\details{
\describe{
  \item{\code{GLMModel} Response types:}{\code{BinomialVariate},
    \code{factor}, \code{matrix}, \code{NegBinomialVariate},
    \code{numeric}, \code{PoissonVariate}}
  \item{\code{GLMStepAICModel} Response types:}{\code{binary factor},
    \code{BinomialVariate}, \code{NegBinomialVariate}, \code{numeric},
    \code{PoissonVariate}}
}

Default values and further model details can be found in the source links
below.

In calls to \code{\link{varimp}} for \code{GLMModel} and
\code{GLMStepAICModel}, numeric argument \code{base} may be specified for the
(negative) logarithmic transformation of p-values [defaul: \code{exp(1)}].
Transformed p-values are automatically scaled in the calculation of variable
importance to range from 0 to 100.  To obtain unscaled importance values, set
\code{scale = FALSE}.
}
\examples{
fit(sale_amount ~ ., data = ICHomes, model = GLMModel)

}
\seealso{
\code{\link[stats]{glm}}, \code{\link[stats]{glm.control}},
\code{\link[MASS]{stepAIC}}, \code{\link{fit}}, \code{\link{resample}}
}
