% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.wimids.R
\name{summary.wimids}
\alias{summary.wimids}
\title{Summarizes a \code{wimids} Class Object}
\usage{
\method{summary}{wimids}(object, n = 1, interactions = FALSE,
  addlvariables = NULL, standardize = FALSE, ...)
}
\arguments{
\item{object}{This argument specifies an object of the \code{wimids} class.}

\item{n}{This argument specifies number of the weighted imputed dataset intended to summarize its matching profile. The input must be a positive integer. The default is \code{1}.}

\item{interactions}{This argument specifies whether to show the balance of all squares and interactions of the covariates used in the weighting procedure. The input must be a logical value. The default is \code{FALSE}}

\item{addlvariables}{This argument specifies whether to provide balance measures on additional variables not included in the original weighting procedure. The input should be a list. The default is \code{NULL}}

\item{standardize}{This argument specifies whether to print out standardized versions of the balance measures, where the mean difference is standardized (divided) by the standard deviation in the original treated group. The input must be a logical value. The default is \code{FALSE}.}

\item{...}{Additional arguments to be passed to the \code{summary.wimids()} function.}
}
\description{
The \code{summary.wimids()} function summarizes an object of the \code{wimids} class.
}
\details{
The matching profile of the \code{wimids} class objects is summarized.
}
\examples{

\donttest{

#Loading the 'handoa' dataset
data(handoa)

#Imputing the missing data points in the 'handoa' dataset
datasets <- mice(handoa, m = 5, maxit = 1,
                 method = c("", "", "", "mean", "polyreg", "logreg", "", ""))

#Weighting the imputed datasets, 'datasets'
weighteddatasets <- weightitmice(HANDOA ~ SEX + AGE, datasets)

#Summarizing data of the first imputed dataset
summ1 <- summary(weighteddatasets, n = 1)

}
}
\references{
Daniel Ho, Kosuke Imai, Gary King, and Elizabeth Stuart (2007). Matching as Nonparametric Preprocessing for Reducing Model Dependence in Parametric Causal Inference. \emph{Political Analysis}, 15(3): 199-236. \url{http://gking.harvard.edu/files/abs/matchp-abs.shtml}
}
\seealso{
\code{\link[=wimids]{wimids}}
}
\author{
Farhad Pishgar
}
