% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_addColumn.R
\name{table_addColumn}
\alias{table_addColumn}
\title{Add a new column of metadata to a table}
\usage{
table_addColumn(locationTbl = NULL, columnName = NULL,
  locationID = NULL, locationData = NULL, verbose = TRUE)
}
\arguments{
\item{locationTbl}{Tibble of known locations, Default: NULL}

\item{columnName}{Name to use for the new column, Default: NULL}

\item{locationID}{Vector of \code{locationID} strings, Default: NULL}

\item{locationData}{Vector of data to used at matching records, Default: NULL}

\item{verbose}{Logical controlling the generation of progress messages.}
}
\value{
Updated tibble of known locations.
}
\description{
A new metadata column is added to the \code{locationTbl}. For
matching \code{locationID} records the assaociated \code{locatioData} is
inserted. Otherwise, the new column will be initialized with \code{NA}.
}
\examples{
# Starting table
locationTbl <- get(data("wa_monitors_500")) 
names(locationTbl)

# Add an empty column
locationTbl <-
  locationTbl \%>\%
  table_addColumn("siteName")
  
names(locationTbl)
}
\seealso{
\link{table_removeColumn}

\link{table_updateColumn}
}
