% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_removeRecord.R
\name{table_removeRecord}
\alias{table_removeRecord}
\title{Remove location records from a table}
\usage{
table_removeRecord(locationTbl = NULL, locationID = NULL, verbose = TRUE)
}
\arguments{
\item{locationTbl}{Tibble of known locations.}

\item{locationID}{Vector of \code{locationID} strings.}

\item{verbose}{Logical controlling the generation of progress messages.}
}
\value{
Updated tibble of known locations.
}
\description{
Incoming \code{locationID} values are compared 
against the incoming \code{locationTbl} and any matches are removed.
}
\examples{
library(MazamaLocationUtils)

locationTbl <- get(data("wa_monitors_500"))
dim(locationTbl)

# Wenatchee
lon <- -120.325278
lat <- 47.423333

# Get the locationID first
locationID <- table_getLocationID(locationTbl, lon, lat, distanceThreshold = 500)

# Remove it
locationTbl <- table_removeRecord(locationTbl, locationID)
dim(locationTbl)

# Test
table_getLocationID(locationTbl, lon, lat, distanceThreshold = 500)
}
\seealso{
\link{table_addLocation}

\link{table_addSingleLocation}

\link{table_updateSingleRecord}
}
