% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/location_getSingleAddress_TexasAM.R
\name{location_getSingleAddress_TexasAM}
\alias{location_getSingleAddress_TexasAM}
\title{Get an address from a Texas A&M web service}
\usage{
location_getSingleAddress_TexasAM(
  longitude = NULL,
  latitude = NULL,
  apiKey = NULL,
  verbose = TRUE
)
}
\arguments{
\item{longitude}{Single longitude in decimal degrees E.}

\item{latitude}{Single latitude in decimal degrees N.}

\item{apiKey}{Texas A&M Geocoding requires an API key. The first 2500 requests
are free. Default: NULL}

\item{verbose}{Logical controlling the generation of progress messages.}
}
\value{
Numeric elevation value.
}
\description{
Texas A&M APIs are used to determine the address associated with
the \code{longitude} and \code{latitude}.
}
\examples{
\dontrun{
library(MazamaLocationUtils)

# Fail gracefully if any resources are not available
try({

  # Set up standard directories and spatial data
  spatialDataDir <- tempdir() # typically "~/Data/Spatial"
  mazama_initialize(spatialDataDir)

  # Wenatchee
  longitude <- -122.47
  latitude <- 47.47
  apiKey <- YOUR_PERSONAL_API_KEY

  location_getSingleAddress_TexasAM(longitude, latitude, apiKey)
  
}, silent = FALSE)
}

}
\references{
\url{https://geoservices.tamu.edu/Services/ReverseGeocoding/WebService/v04_01/HTTP.aspx}
}
