% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_findAdjacentLocations.R
\name{table_findAdjacentLocations}
\alias{table_findAdjacentLocations}
\title{Finds adjacent locations in a known locations table.}
\usage{
table_findAdjacentLocations(
  locationTbl = NULL,
  distanceThreshold = NULL,
  measure = c("geodesic", "haversine", "vincenty", "cheap")
)
}
\arguments{
\item{locationTbl}{Tibble of known locations.}

\item{distanceThreshold}{Distance in meters.}

\item{measure}{One of "haversine" "vincenty", "geodesic", or "cheap"
specifying desired method of geodesic distance calculation.

See \code{geodist::\link[geodist:geodist]{geodist}} for details.}
}
\value{
Tibble of known locations separated by less than
\code{distanceThreshold} meters.
}
\description{
Calculate distances between all locations within a known
locations table and return a tibble containing all records that have an
adjacent location separated by less than \code{distanceThreshold} meters.
The return tibble is ordered by separation distance.

It is useful when working with new metadata tables to identify adjacent
locations early on so that decisions can be made about the appropriateness
of the specified \code{distanceThreshold}.
}
\note{
The measure \code{"cheap"} may be used to speed things up depending on
the spatial scale being considered. Distances calculated with
\code{measure = "cheap"} will vary by a few meters compared with those
calculated using \code{measure = "geodesic"}.
}
\examples{
library(MazamaLocationUtils)

meta <- wa_airfire_meta

# Any locations closer than 2 km?
meta \%>\%
  table_findAdjacentLocations(distanceThreshold = 2000) \%>\%
  dplyr::select(AQSID, timezone)

# How about 4 km?
meta \%>\%
  table_findAdjacentLocations(distanceThreshold = 4000) \%>\%
  dplyr::select(AQSID, timezone)

}
