% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{USCensusCounties_02}
\alias{USCensusCounties_02}
\title{US Census Counties simple features data frame}
\format{
A simple features data frame (SFDF) with 3169 observations and 9 variables.
}
\usage{
USCensusCounties_02
}
\description{
The \code{USCensusCounties_02} dataset provides a SFDF of US counties to
use in code examples. It is created from converting a US county borders
shapefile to a simple features data frame with additional columns of data. The
code for creating it demonstrates creation of a SFDF that is
compatible with \code{countyMap()}. See the \pkg{MazamaSpatialUtils} package for the
function \code{convertUSCensusCounties()} that creates this SFDF.

This dataset was generated on 2022-11-07 by running:

\preformatted{
library(MazamaSpatialUtils)

setSpatialDataDir("~/Data/Spatial_0.8")

MazamaSpatialUtils::convertUSCensusCounties()

MazamaSpatialUtils::loadSpatialData("USCensusCounties_02")

save(USCensusCounties_02, file = "data/USCensusCounties_02.rda")
}
}
\keyword{datasets}
