% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertSimpleTimezones.R
\name{convertSimpleTimezones}
\alias{convertSimpleTimezones}
\title{Convert SimpleTimezones Shapefile}
\usage{
convertSimpleTimezones(nameOnly = FALSE)
}
\arguments{
\item{nameOnly}{logical specifying whether to only return the name without creating the file}
}
\value{
Name of the dataset being created.
}
\description{
A world timezone shapefile is downloaded from \url{http://efele.net/maps/tz/world/}
and converted to a SpatialPolygonsDataFrame with additional columns of data. The resulting file will be created
in the spatial data directory which is set with \code{setSpatialDataDir()}.
}
\note{
The following list of timezones have polygons but the associated rows in the dataframe have no data.
These timezones also have no \code{countryCode} assigned. We hope to rectify this in a future release.
\preformatted{
> WorldTimezones@data$timezone[is.na(WorldTimezones$countryCode)]
[1] "Europe/Zagreb"         "Europe/Vatican"        "America/Coral_Harbour"
[4] "Arctic/Longyearbyen"   "uninhabited"           "America/Kralendijk"
[7] "Europe/Jersey"         "Europe/Bratislava"     "America/St_Barthelemy"
[10] "Europe/Ljubljana"      "Europe/Mariehamn"      "Europe/Podgorica"
[13] "Europe/Isle_of_Man"    "Europe/Guernsey"       "Europe/San_Marino"
[16] "Europe/Skopje"         "Europe/Sarajevo"       "America/Lower_Princes"
[19] "America/Marigot"       "Africa/Juba"
}

This is a non-exported function used only for updating the package dataset.
}
\examples{
\dontrun{
setSpatialDataDir(getwd()) # directory
convertSimpleCountries()
}
}
\references{
\url{http://efele.net/maps/tz/world/}
}
\seealso{
setSpatialDataDir

convertWikipediaTimezoneTable
}
\keyword{datagen}
