% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getStateName.R
\name{getStateName}
\alias{getStateName}
\title{Return state names at specified locations}
\usage{
getStateName(lon, lat, dataset = "NaturalEarthAdm1",
  countryCodes = NULL, allData = FALSE, useBuffering = FALSE)
}
\arguments{
\item{lon}{vector of longitudes in decimal degrees}

\item{lat}{vector of latitudes in decimal degrees}

\item{dataset}{name of spatial dataset to use}

\item{countryCodes}{vector of country codes}

\item{allData}{logical specifying whether a full dataframe should be returned}

\item{useBuffering}{logical flag specifying the use of location buffering to 
find the nearest polygon if no target polygon is found}
}
\value{
Vector of state names in English
}
\description{
Uses spatial comparison to determine which 'state' polygons the 
locations fall into and returns the ISO 3166-2 2-character state code
strings for those polygons.
    
Specification of \code{countryCodes} limits spatial searching to the 
specified countries and greatly improves performance.
    
If \code{allData = TRUE}, additional data is returned.
}
\examples{
\dontrun{
lon <- seq(-140,-90)
lat <- seq(20,70)
getStateName(lon,lat)
}
}
\seealso{
getSpatialData
}
\keyword{locator}
