% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getHUC.R
\name{getHUC}
\alias{getHUC}
\title{Return HUCs at specified locations}
\usage{
getHUC(
  longitude,
  latitude,
  dataset = NULL,
  HUCs = NULL,
  allData = FALSE,
  useBuffering = FALSE
)
}
\arguments{
\item{longitude}{Vector of longitudes in decimal degrees East.}

\item{latitude}{Vector of latitudes in decimal degrees North.}

\item{dataset}{Name of spatial dataset to use.}

\item{HUCs}{Vector of Hydrologic Unit Codes.}

\item{allData}{logical specifying whether a full dataframe should be returned}

\item{useBuffering}{Logical flag specifying the use of location buffering to
find the nearest polygon if not target polygon is found.}
}
\value{
Vector of HUC identifiers.
}
\description{
Uses spatial comparison to determine which HUC polygons the
locations fall into and returns the HUC identifier strings for those polygons.

If \code{allData = TRUE}, additional data is returned.
}
\seealso{
getSpatialData
}
\keyword{locator}
