% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mts_summarize.R
\name{mts_summarize}
\alias{mts_summarize}
\title{Create summary time series for an \emph{mts} time series object}
\usage{
mts_summarize(
  mts,
  timezone = NULL,
  unit = c("day", "week", "month", "year"),
  FUN = NULL,
  ...,
  minCount = NULL
)
}
\arguments{
\item{mts}{\emph{mts} object.}

\item{timezone}{Olson timezone used to interpret dates.}

\item{unit}{Unit used to summarize by (\emph{e.g.} "day").}

\item{FUN}{Function used to summarize time series.}

\item{...}{Additional arguments to be passed to \code{FUN}
(_e.g._ \code{na.rm = TRUE}).}

\item{minCount}{Minimum number of valid data records required to calculate
summaries. Time periods with fewer valid records will be assigned \code{NA}.}
}
\value{
An \emph{mts} time series object containing daily (or other)
statistical summaries.
(A list with \code{meta} and \code{data} dataframes.)
}
\description{
Individual time series in \code{mts$data} are grouped by \code{unit} and then
summarized using \code{FUN}.

The most typical use case is creating daily averages where each day begins at
midnight. This function interprets times using the \code{mts$data$datetime}
\code{tzone} attribute so be sure that is set properly.

Day boundaries are calculated using the specified \code{timezone} or, if
\code{NULL}, the most common (hopefully only!) time zone found in
\code{mts$meta$timezone}. Leaving \code{timezone = NULL}, the default,
results in "local time" date filtering which is the most common use case.
}
\note{
Because the returned \emph{mts} object is defined on a daily axis in a
specific time zone, it is important that the incoming \code{mts} contain
timeseries associated with a single time zone.
}
\examples{
library(MazamaTimeSeries)

daily <-
  mts_summarize(
    mts = Carmel_Valley,
    timezone = NULL,
    unit = "day",
    FUN = mean,
    na.rm = TRUE,
    minCount = 18
  )

# Daily means
head(daily$data)

}
