% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mts_trimDate.R
\name{mts_trimDate}
\alias{mts_trimDate}
\title{Trim \emph{mts} time series object to full days}
\usage{
mts_trimDate(mts = NULL, timezone = NULL, trimEmptyDays = TRUE)
}
\arguments{
\item{mts}{\emph{mts} object.}

\item{timezone}{Olson timezone used to interpret dates.}

\item{trimEmptyDays}{Logical specifying whether to remove days with no data
at the beginning and end of the time range.}
}
\value{
A subset of the incoming \emph{mts} time series object.
(A list with \code{meta} and \code{data} dataframes.)
}
\description{
Trims the date range of an \emph{mts} object to local time date
boundaries which are within the time range of the \emph{mts} object.
This has the effect of removing partial-day data records at the start and
end of the timeseries and is useful when calculating full-day statistics.

By default, multi-day periods of all-missing data at the beginning and end
of the timeseries are removed before trimming to date boundaries. If
\code{trimEmptyDays = FALSE} all records are retained except for partial days
beyond the first and after the last date boundary.

Day boundaries are calculated using the specified \code{timezone} or, if
\code{NULL},  \code{mts$meta$timezone}. Leaving \code{timezone = NULL}, the
default, results in "local time" date filtering which is the most
common use case.
}
\examples{
library(MazamaTimeSeries)

UTC_week <- mts_filterDate(
  example_mts,
  startdate = 20190703,
  enddate = 20190706,
  timezone = "UTC"
)

# UTC day boundaries
range(UTC_week$data$datetime)

# Trim to local time day boundaries
local_week <- mts_trimDate(UTC_week)
range(local_week$data$datetime)

}
