% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mega2genabeltst.R
\name{Mega2GenABELtst}
\alias{Mega2GenABELtst}
\title{compare two gwaa.data-class objects}
\usage{
Mega2GenABELtst(mega_ = mega, gwaa_ = srdta, full = TRUE, envir = ENV)
}
\arguments{
\item{mega_}{name of first gwaa.data-class object}

\item{gwaa_}{name of second gwaa.data-class object}

\item{full}{if TRUE convert genotypes to text as.character(gwaa_@gtdata)\cr and as.character(mega_@gtdata).
Then standardize the order for heterozygous alleles and finally compare.
This step is optional because it can be rather slow.}

\item{envir}{'environment' containing SQLite database and other globals}
}
\value{
None
}
\description{
Verify by fields, all the fields in two gwaa.data-class objects.
 Show more detailed marker information iff the coding values are different.  (When comparing
 two gwaa.data-class objects, one native and one created via \bold{Mega2R} sometimes
 when an allele frequency is .5 for both alleles, the allele order 1/2 vs 2/1 can not be
 currently be determined.)
}
\examples{
db = system.file("exdata", "seqsimm.db", package="Mega2R")
require("GenABEL")
ENV = read.Mega2DB(db)

y = Mega2ENVGenABEL()
Mega2GenABELtst(y, y, full = FALSE)

\donttest{
# donttestcheck: if you have more time, try ...
x = Mega2GenABEL()
Mega2GenABELtst(x, y, full = FALSE)
}

}
