% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_kraken_assignment.R
\name{load_kraken_assignment}
\alias{load_kraken_assignment}
\title{Efficiently loads a EDGE-produced Kraken taxonomic assignment from a file.
An assumption has been made -- since Kraken/EDGE tables are generated in an automated fashion,
they should be properly formatted -- thus the code doesn't check for any inconsistencies except
for the very file existence. Note however, the unassigned to taxa entries are removed.
This implementation fully relies on the read.table function from data.table package
gaining performance over traditional R techniques.}
\usage{
load_kraken_assignment(filepath)
}
\arguments{
\item{filepath}{A path to EDGE-generated tab-delimeted Kraken taxonomy assignment file.}
}
\value{
a data frame containing four columns: TAXA, LEVEL, COUNT, and ABUNDANCE, representing
        taxonomically anchored sequences from the sample.
}
\description{
Efficiently loads a EDGE-produced Kraken taxonomic assignment from a file.
An assumption has been made -- since Kraken/EDGE tables are generated in an automated fashion,
they should be properly formatted -- thus the code doesn't check for any inconsistencies except
for the very file existence. Note however, the unassigned to taxa entries are removed.
This implementation fully relies on the read.table function from data.table package
gaining performance over traditional R techniques.
}
