% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\name{MetaRVMSummary}
\alias{MetaRVMSummary}
\title{MetaRVM Summary Class}
\description{
R6 class for summarized MetaRVM results with plotting capabilities and method chaining support.
This class stores summarized simulation data and provides visualization methods that automatically
adapt based on the data structure and grouping variables.
}
\details{
The MetaRVMSummary class is designed to work seamlessly with method chaining from MetaRVMResults.
It stores either summary statistics (mean, median, quantiles, etc.) or individual instance data,
and provides intelligent plotting methods that automatically determine appropriate visualizations
based on the data structure and demographic groupings.

The class supports two data types:
\itemize{
\item \strong{Summary data}: Contains aggregated statistics across simulation instances
\item \strong{Instance data}: Contains individual trajectory data for each simulation instance
}

Plotting behavior adapts automatically:
\itemize{
\item Single grouping variable: Facets by demographic category, colors by disease state
\item Two grouping variables: Grid layout with both demographics as facet dimensions
\item Three grouping variables: Grid layout with first two as facets, third as color
}
}
\section{Public Fields}{

\describe{
\item{\code{data}}{data.table containing summarized results}
\item{\code{config}}{MetaRVMConfig object from original simulation}
\item{\code{type}}{Character string indicating data type ("summary" or "instances")}
}
}

\examples{
\donttest{
options(odin.verbose = FALSE)
example_config <- system.file("extdata", "example_config_dist.yaml", package = "MetaRVM")
# Run simulation
results <- metaRVM(example_config)
# Typically created through method chaining
summary_obj <- results$subset_data(disease_state = "H")$summarize(
  group_by = c("age", "race"), 
  stats = c("median", "quantile"),
  quantiles = c(0.25, 0.75)
)

# Direct plotting
summary_obj$plot()

# Plot with custom ggplot theme and confidence level
summary_obj$plot(theme = ggplot2::theme_bw())
}

}
\author{
Arindam Fadikar
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{data}}{Summarized data}

\item{\code{config}}{Original MetaRVMConfig object}

\item{\code{type}}{Type of summary ("instances" or "summary")}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-MetaRVMSummary-new}{\code{MetaRVMSummary$new()}}
\item \href{#method-MetaRVMSummary-print}{\code{MetaRVMSummary$print()}}
\item \href{#method-MetaRVMSummary-plot}{\code{MetaRVMSummary$plot()}}
\item \href{#method-MetaRVMSummary-clone}{\code{MetaRVMSummary$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MetaRVMSummary-new"></a>}}
\if{latex}{\out{\hypertarget{method-MetaRVMSummary-new}{}}}
\subsection{Method \code{new()}}{
Initialize MetaRVMSummary object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MetaRVMSummary$new(data, config, type)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{data.table containing summarized or instance data}

\item{\code{config}}{MetaRVMConfig object from original simulation}

\item{\code{type}}{Character string indicating data type ("summary" or "instances")}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
New MetaRVMSummary object (invisible)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MetaRVMSummary-print"></a>}}
\if{latex}{\out{\hypertarget{method-MetaRVMSummary-print}{}}}
\subsection{Method \code{print()}}{
Print summary of the data object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MetaRVMSummary$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Self (invisible)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MetaRVMSummary-plot"></a>}}
\if{latex}{\out{\hypertarget{method-MetaRVMSummary-plot}{}}}
\subsection{Method \code{plot()}}{
Plot method that shows median with quantile bands
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MetaRVMSummary$plot(ci_level = 0.95, theme = theme_minimal(), title = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ci_level}}{Confidence level for empirical quantiles (default: 0.95). Only used if quantile columns are not pre-specified}

\item{\code{theme}}{ggplot2 theme function (default: theme_minimal())}

\item{\code{title}}{Optional custom plot title}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
This method creates time series plots with automatic layout adaptation based on grouping variables:
\itemize{
\item For summary data: Shows median lines with quantile confidence bands
\item Automatically determines faceting strategy based on number of grouping variables
\item Uses disease states for color differentiation when appropriate
}

The method requires specific data structure:
\itemize{
\item Summary data must contain 'median_value' and quantile columns (e.g., 'q25', 'q75')
\item Instance data must contain 'instance' column for individual trajectory grouping
}
}

\subsection{Returns}{
ggplot object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MetaRVMSummary-clone"></a>}}
\if{latex}{\out{\hypertarget{method-MetaRVMSummary-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MetaRVMSummary$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
