% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regression.R
\name{smape}
\alias{smape}
\title{Symmetric Mean Absolute Percentage Error}
\usage{
smape(actual, predicted)
}
\arguments{
\item{actual}{The ground truth numeric vector.}

\item{predicted}{The predicted numeric vector, where each element in the vector
is a prediction for the corresponding element in \code{actual}.}
}
\description{
\code{smape} computes the symmetric mean absolute percentage error between
two numeric vectors.
}
\details{
\code{smape} is defined as two times the average of \code{abs(actual - predicted) / (abs(actual) + abs(predicted))}.
Therefore, at the elementwise level, it will provide \code{NaN} only if \code{actual} and \code{predicted}
are both zero. It has an upper bound of \code{2}, when either \code{actual} or
\code{predicted} are zero or when \code{actual} and \code{predicted} are opposite
signs.

\code{smape} is symmetric in the sense that \code{smape(x, y) = smape(y, x)}.
}
\examples{
actual <- c(1.1, 1.9, 3.0, 4.4, 5.0, 5.6)
predicted <- c(0.9, 1.8, 2.5, 4.5, 5.0, 6.2)
smape(actual, predicted)
}
\seealso{
\code{\link{mape}} \code{\link{mase}}
}
