% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{weighted_quantile}
\alias{weighted_quantile}
\title{Weighted Quantiles}
\usage{
weighted_quantile(
  x,
  w = NULL,
  probs = seq(0, 1, 0.25),
  na.rm = TRUE,
  names = TRUE,
  ...
)
}
\arguments{
\item{x}{Numeric vector.}

\item{w}{Optional vector of non-negative case weights.}

\item{probs}{Vector of probabilities.}

\item{na.rm}{Ignore missing data? Default is \code{TRUE}.}

\item{names}{Return names? Default is \code{TRUE}.}

\item{...}{Further arguments passed to \code{\link[stats:quantile]{stats::quantile()}} in the unweighted case.
Not used in the weighted case.}
}
\value{
A length-one numeric vector.
}
\description{
Calculates weighted quantiles based on the generalized inverse of the weighted ECDF.
If no weights are passed, uses \code{\link[stats:quantile]{stats::quantile()}}.
}
\examples{
n <- 10
x <- seq_len(n)
quantile(x)
weighted_quantile(x)
weighted_quantile(x, w = rep(1, n))
quantile(x, type = 1)
weighted_quantile(x, w = x) # same as Hmisc::wtd.quantile()
weighted_quantile(x, w = x, names = FALSE)
weighted_quantile(x, w = x, probs = 0.5, names = FALSE)

# Example with integer weights
x <- c(1, 1:11, 11, 11)
w <- seq_along(x)
weighted_quantile(x, w)
quantile(rep(x, w)) # same
}
\seealso{
\code{\link[=weighted_median]{weighted_median()}}
}
