% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification.R
\name{classification}
\alias{classification}
\alias{accuracy}
\alias{classification_error}
\alias{precision}
\alias{recall}
\alias{f1_score}
\alias{AUC}
\alias{gini_coefficient}
\alias{deviance_bernoulli}
\alias{logLoss}
\title{Classification Metrics}
\usage{
accuracy(actual, predicted, w = NULL, ...)

classification_error(actual, predicted, w = NULL, ...)

precision(actual, predicted, w = NULL, ...)

recall(actual, predicted, w = NULL, ...)

f1_score(actual, predicted, w = NULL, ...)

AUC(actual, predicted, w = NULL, ...)

gini_coefficient(actual, predicted, w = NULL, ...)

deviance_bernoulli(actual, predicted, w = NULL, ...)

logLoss(actual, predicted, w = NULL, ...)
}
\arguments{
\item{actual}{Observed values.}

\item{predicted}{Predicted values.}

\item{w}{Optional case weights.}

\item{...}{Further arguments passed to \code{\link[=weighted_mean]{weighted_mean()}}
(no effect for \code{AUC()} and \code{gini_coefficient()}).}
}
\value{
A numeric vector of length one.
}
\description{
Weighted versions of non-probabilistic and probabilistic classification metrics:
\itemize{
\item \code{accuracy()}: Accuracy (higher is better).
\item \code{classification_error()}: Classification error = 1 - Accuracy (lower is better).
\item \code{precision()}: Precision (higher is better).
\item \code{recall()}: Recall (higher is better).
\item \code{f1_score()}: F1 Score. Harmonic mean of precision and recall (higher is better).
\item \code{AUC()}: Area under the ROC (higher is better).
\item \code{gini_coefficient()}: Gini coefficient, equivalent to \eqn{2 \cdot \textrm{AUC} - 1}.
Up to ties in \code{predicted}, equivalent to Somer's D (higher is better).
\item \code{deviance_bernoulli()}: Average Bernoulli deviance. Equals twice the
log loss/binary cross entropy (smaller is better).
\item \code{logLoss()}: Log loss/binary cross entropy. Equals half the average Bernoulli
deviance (smaller is better).
}
}
\details{
Note that the function \code{AUC()} was originally modified from the 'glmnet' package
to ensure deterministic results. The unweighted version can be different from the
weighted one with unit weights due to ties in \code{predicted}.
}
\section{Input ranges}{

\itemize{
\item For \code{precision()}, \code{recall()}, and \code{f1_score()}: The \code{actual} and \code{predicted} values
need to be in \eqn{\{0, 1\}}.
\item For \code{accuracy()} and \code{classification_error()}: Any discrete input.
\item For \code{AUC()} and \code{gini_coefficient()}: Only \code{actual} must be in \eqn{\{0, 1\}}.
\item For \code{deviance_bernoulli()} and \code{logLoss()}: The values of \code{actual} must be in
\eqn{\{0, 1\}}, while \code{predicted} must be in the closed interval \eqn{[0, 1]}.
}
}

\examples{
y <- c(0, 0, 1, 1)
pred <- c(0, 0, 1, 0)
w <- y * 2

accuracy(y, pred)
classification_error(y, pred, w = w)
precision(y, pred, w = w)
recall(y, pred, w = w)
f1_score(y, pred, w = w)

y2 <- c(0, 1, 0, 1)
pred2 <- c(0.1, 0.1, 0.9, 0.8)
w2 <- 1:4

AUC(y2, pred2)
AUC(y2, pred2, w = rep(1, 4))  # Different due to ties in predicted

gini_coefficient(y2, pred2, w = w2)
logLoss(y2, pred2, w = w2)
deviance_bernoulli(y2, pred2, w = w2)
}
