% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/D2K.R
\name{D2K}
\alias{D2K}
\title{D2K}
\usage{
D2K(D)
}
\arguments{
\item{D}{An n by n matrix giving pairwise distances or dissimilarites, where n is sample size.}
}
\value{
An n by n kernel or similarity matrix corresponding to the distance matrix given.
}
\description{
Construct kernel matrix from distance matrix.
}
\details{
Converts a distance matrix (matrix of pairwise distances) into a kernel matrix for microbiome data. The kernel matrix is constructed as \eqn{K = -(I-11'/n)D^2(I-11'/n)/2}, where D is the pairwise distance matrix, I is the identity
matrix, and 1 is a vector of ones.

\eqn{D^2} represents element-wise square.

To ensure that \eqn{K} is positive semi-definite, a positive semi-definiteness correction is conducted
}
\examples{
library(GUniFrac)

#Load in data and create a distance matrix
data(throat.tree)
data(throat.otu.tab)
unifracs <- GUniFrac(throat.otu.tab, throat.tree, alpha=c(1))$unifracs
D1 <- unifracs[,,"d_1"]

#Function call
K <- D2K(D1)

}
\references{
Zhao, Ni, et al. "Testing in microbiome-profiling studies with MiRKAT, the microbiome regression-based kernel association test
}
\author{
Ni Zhao
}
