% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{tax_bar_pq}
\alias{tax_bar_pq}
\title{Plot the distribution of sequences or ASV in one taxonomic levels}
\usage{
tax_bar_pq(
  physeq,
  fact = "Sample",
  taxa = "Order",
  percent_bar = FALSE,
  nb_seq = TRUE
)
}
\arguments{
\item{physeq}{(required): a \code{\link[phyloseq]{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{fact}{Name of the factor to cluster samples by modalities.
Need to be in \code{physeq@sam_data}.}

\item{taxa}{(default: 'Order') Name of the taxonomic rank of interest}

\item{percent_bar}{(default FALSE) If TRUE, the stacked bar fill all
the space between 0 and 1. It just set position = "fill" in the
\code{ggplot2::geom_bar()} function}

\item{nb_seq}{(logical; default TRUE) If set to FALSE, only the number of ASV
is count. Concretely, physeq otu_table is transformed in a binary
otu_table (each value different from zero is set to one)}
}
\value{
A \code{\link[ggplot2]{ggplot}}2 plot  with bar representing the number of sequence en each
taxonomic groups
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-experimental-orange" alt="lifecycle-experimental"></a>
}}


Graphical representation of distribution of taxonomy, optionnaly across a factor.
}
\examples{

data_fungi_ab <- subset_taxa_pq(data_fungi, taxa_sums(data_fungi) > 10000)
tax_bar_pq(data_fungi_ab) + theme(legend.position = "none")
\donttest{
tax_bar_pq(data_fungi_ab, taxa = "Class")
tax_bar_pq(data_fungi_ab, taxa = "Class", percent_bar = TRUE)
tax_bar_pq(data_fungi_ab, taxa = "Class", fact = "Time")
}
}
\seealso{
\code{\link[=plot_tax_pq]{plot_tax_pq()}} and \code{\link[=multitax_bar_pq]{multitax_bar_pq()}}
}
\author{
Adrien Taudière
}
