% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dada_phyloseq.R
\name{filt_taxa_wo_NA}
\alias{filt_taxa_wo_NA}
\title{Filter taxa by cleaning taxa with NA at given taxonomic rank(s)}
\usage{
filt_taxa_wo_NA(
  physeq,
  taxa_ranks = NULL,
  n_NA = 0,
  verbose = TRUE,
  NA_equivalent = NULL,
  clean_pq = TRUE
)
}
\arguments{
\item{physeq}{(required): a \code{\link[phyloseq]{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{taxa_ranks}{A vector of taxonomic ranks. For examples c("Family","Genus").
If taxa_ranks is NULL (default), all ranks are used, i.e. all taxa with at least 1 NA
will be filtered out. Numeric position of taxonomic ranks can also be used.}

\item{n_NA}{(int default = 0). Number of allowed NA by taxa in the list of the
taxonomic ranks}

\item{verbose}{(logical). If TRUE, print additional information.}

\item{NA_equivalent}{(vector of character, default NULL). Exact matching of
the character listed in the vector are converted as NA before to filter out
taxa.}

\item{clean_pq}{(logical, default TRUE)
If set to TRUE, empty samples are discarded after filtering. See \code{\link[=clean_pq]{clean_pq()}}.}
}
\value{
An object of class phyloseq
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-experimental-orange" alt="lifecycle-experimental"></a>
}}


Basically a wrapper of subset_taxa_pq()
}
\examples{

data_fungi_wo_NA <- filt_taxa_wo_NA(data_fungi)
filt_taxa_wo_NA(data_fungi, n_NA = 1)
filt_taxa_wo_NA(data_fungi, taxa_ranks = c(1:3))

filt_taxa_wo_NA(data_fungi, taxa_ranks = c("Trait", "Confidence.Ranking"))
filt_taxa_wo_NA(data_fungi,
  taxa_ranks = c("Trait", "Confidence.Ranking"),
  NA_equivalent = c("-", "NULL")
)
}
\seealso{
\code{\link[=subset_taxa_pq]{subset_taxa_pq()}}
}
\author{
Adrien Taudière
}
