% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixbino.R
\name{mixbinosemi}
\alias{mixbinosemi}
\title{Semiparametric Mixture of Binomial Regression with a Degenerate Component}
\usage{
mixbinosemi(tg, t, x, N, h = NULL)
}
\arguments{
\item{tg}{the grid points on which we want to evaluate the function w(t) and p(t).}

\item{t}{the time variable associated with x.}

\item{x}{the integer observation.}

\item{N}{the number of experiments for Binomial distribution.}

\item{h}{the bandwidth. If NULL, will be estimated by local constant regression suggested by Bowman and Azzalini (1997) p.31.}
}
\value{
w contains the estimate of first component proportion function
pt is the estimate of component probability function for the first component
h the bandwidth
}
\description{
Fits the semiparametric mixture of binomial distribution with one degenerate component
\cr \eqn{w*B(N,0)+(1-w)*B(N,p(t))}
}
\examples{
n=100;tg=seq(from=0,to=1,length.out=50);t=seq(from=0,to=1,length.out=n);
pt=0.5*(1-cos(2*pi*t));
b=rbinom(n,1,0.2);
y=numeric();
for(i in 1:n){
 if(b[i]==1){
  y[i]=0;
  }else{
      y[i]=rbinom(1,7,pt[i]);
        }
        }
 ft=mixbinosemi(tg,t,y,7);
}
