% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MixtureMissing.R
\name{print.MixtureMissing}
\alias{print.MixtureMissing}
\title{Print for MixtureMissing}
\usage{
\method{print}{MixtureMissing}(x, ...)
}
\arguments{
\item{x}{A \code{MixtureMissing} object or an output of \link[MixtureMissing]{select_mixture}.
In the latter, only the best model will be considered.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
No return value, called to print the fitted model's description.
}
\description{
Print \code{MixtureMissing} object.
}
\details{
The description includes information on the complete or incomplete data,
  number of clusters, and component distribution.
}
\examples{

#++++ With no missing values ++++#

X <- iris[, 1:4]
mod <- MGHM(X, G = 2, model = 'GH', max_iter = 10)
print(mod)

#++++ With missing values ++++#

set.seed(123)
X <- hide_values(iris[, 1:4], n_cases = 20)
mod <- MGHM(X, G = 2, model = 'GH', max_iter = 10)
print(mod)

}
