% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{MoE_aitken}
\alias{MoE_aitken}
\title{Aitken Acceleration}
\usage{
MoE_aitken(loglik)
}
\arguments{
\item{loglik}{A vector of three consecutive log-likelihood values. These three values should be in ascending order, though this is not checked.}
}
\value{
A list with the following components:
\item{\code{ll}}{The most current estimate for the log-likelihood.}
\item{\code{linf}}{The most current estimate of the final converged maxmised log-likelihood.}
\item{\code{a}}{The Aitken acceleration value where \code{0 <= a <= 1}.}
}
\description{
Calculates the Aitken acceleration estimate of the final converged maximised log-likelihood under the EM framework.
}
\details{
The final converged maximised log-likelihood can be used to determine convergence of the EM algorithm within \code{\link{MoE_clust}}, i.e. by checking whether the absolute difference in the current and previous estimates of the final converged maximised log-likelihood is less than some tolerance.
}
\note{
Within \code{\link{MoE_clust}}, as specified by the \code{stopping} argument of \code{\link{MoE_control}}, \code{"aitken"} is the default method used to assess convergence. The other option monitors the \code{"relative"} change in log-likelihood against some tolerance. See \code{\link{MoE_control}}.

When the \code{"aitken"} method is employed, the final estimate of the log-likelihood is the value of \code{linf} at convergence, rather than the value of \code{ll} at convergence under the \code{"relative"} option.
}
\examples{
(a1 <- MoE_aitken(-c(449.61534, 442.84221, 436.58999)))
a2  <- MoE_aitken(-c(442.84221, 436.58999, 436.58998))
abs(a2$linf - a1$linf) < 1e-05 #FALSE
a3  <- MoE_aitken(-c(436.58998, 436.58997, 436.58997))
abs(a3$linf - a2$linf) < 1e-05 #TRUE
(ll <- a3$linf)
}
\references{
Boehning, D., Dietz, E., Schaub, R., Schlattmann, P. and Lindsay, B. G. (1994). The distribution of the likelihood ratio for mixtures of densities from the one-parameter exponential family. \emph{Annals of the Institute of Statistical Mathematics}, 46(2): 373-388.
}
\seealso{
\code{\link{MoE_control}}
}
\author{
Keefe Murphy - <\email{keefe.murphy@ucd.ie}>
}
\keyword{control}
