% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{MoE_mahala}
\alias{MoE_mahala}
\title{Mahalanobis Distance Outlier Detection for Multivariate Response}
\usage{
MoE_mahala(fit, resids, squared = FALSE)
}
\arguments{
\item{fit}{A fitted \code{\link[stats]{lm}} model, inheriting either the \code{"mlm"} or \code{"lm"} class.}

\item{resids}{The residuals. Can be residuals for observations included in the model, or residuals arising from predictions on unseen data.}

\item{squared}{A logical. By default (\code{FALSE}), the generalized interpoint distance is computed. Set this flag to \code{TRUE} for the squared value.}
}
\value{
A vector giving the Mahalanobis distance (or square Mahalanobis distance) between fitted values and residuals for each observation.
}
\description{
Computes the Mahalanobis distance between the fitted values and residuals of linear regression models with multivariate or univariate responses.
}
\examples{
data(ais)
hema <- as.matrix(ais[,3:7])
mod  <- lm(hema ~ sex + BMI, data=ais)
res  <- hema - predict(mod)
MoE_mahala(mod, res)
}
\author{
Keefe Murphy - <\email{keefe.murphy@ucd.ie}>
}
\keyword{utility}
