% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mop.R
\name{integralMOP}
\alias{integralMOP}
\title{Integration of MOPs}
\usage{
integralMOP(fx)
}
\arguments{
\item{fx}{An \code{"motbf"} object of subclass \code{'mop'}.}
}
\value{
The non-defined integral of the function.
}
\description{
Method to calculate the non-defined integral of an \code{"motbf"} object of \code{'mte'} subclass.
}
\examples{

## 1. EXAMPLE
X <- rexp(1000)
Px <- univMoTBF(X, POTENTIAL_TYPE="MOP")
integralMOP(Px)

## 2. EXAMPLE
X <- rnorm(1000)
Px <- univMoTBF(X, POTENTIAL_TYPE="MOP")
integralMOP(Px)

\dontrun{
## 3. EXAMPLE
X <- rnorm(1000)
Px <- univMoTBF(X, POTENTIAL_TYPE="MTE")
integralMOP(Px)
## Error in integralMOP(Px): fx is an 'motbf' function but not 'mop' subclass.
class(Px)
subclass(Px)
}
}
\seealso{
\link{univMoTBF} for learning and \link{integralMoTBF} 
for a more complete function to get defined and non-defined integrals
of class \code{"motbf"}.
}
