% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gr-TPS.R
\name{tps_raw}
\alias{tps_raw}
\title{Vanilla Thin Plate Splines}
\usage{
tps_raw(fr, to, amp = 1, over = 1.2, grid.size = 15)
}
\arguments{
\item{fr}{the reference \eqn{(x; y)} coordinates}

\item{to}{the target \eqn{(x; y)} coordinates}

\item{amp}{an amplification factor of differences between \code{fr} and
\code{to}}

\item{over}{\code{numeric} that indicates how much the thin plate splines
extends over the shapes}

\item{grid.size}{\code{numeric} to specify the number of grid cells on the
longer axis on the outlines}
}
\value{
a list with two components: \code{grid} the xy coordinates of sampled
points along the grid; \code{dim} the dimension of the grid.
}
\description{
\code{tps_raw} calculates deformation grids and
returns position of sampled points on it.
}
\examples{
\dontrun{
ms <- MSHAPES(efourier(bot, 10), "type")
b <- ms$shp$beer
w <- ms$shp$whisky
g <- tps_raw(b, w)
ldk_plot(g$grid)

# a wavy plot
ldk_plot(g$grid, pch=NA)
cols_ids <- 1:g$dim[1]
for (i in 1:g$dim[2]) lines(g$grid[cols_ids + (i-1)*g$dim[1], ])
}
}
\seealso{
Other thin plate splines: 
\code{\link{tps2d}()},
\code{\link{tps_arr}()},
\code{\link{tps_grid}()},
\code{\link{tps_iso}()}
}
\concept{thin plate splines}
