% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gr-Coo.R
\name{panel}
\alias{panel}
\alias{panel.Coo}
\alias{panel.Out}
\alias{panel.Opn}
\alias{panel.Ldk}
\title{Family picture of shapes}
\usage{
panel(x, ...)

\method{panel}{Out}(
  x,
  dim,
  cols,
  borders,
  fac,
  palette = col_summer,
  coo_sample = 120,
  names = NULL,
  cex.names = 0.6,
  points = TRUE,
  points.pch = 3,
  points.cex = 0.2,
  points.col,
  ...
)

\method{panel}{Opn}(
  x,
  cols,
  borders,
  fac,
  palette = col_summer,
  coo_sample = 120,
  names = NULL,
  cex.names = 0.6,
  points = TRUE,
  points.pch = 3,
  points.cex = 0.2,
  points.col,
  ...
)

\method{panel}{Ldk}(
  x,
  cols,
  borders,
  fac,
  palette = col_summer,
  names = NULL,
  cex.names = 0.6,
  points = TRUE,
  points.pch = 3,
  points.cex = 0.2,
  points.col = "#333333",
  ...
)
}
\arguments{
\item{x}{The \code{Coo} object to plot.}

\item{...}{additional arguments to feed generic \code{plot}}

\item{dim}{for \link{coo_listpanel}: a numeric of length 2
specifying the dimensions of the panel}

\item{cols}{A \code{vector} of colors for drawing the outlines.
Either a single value or of length exactly equal to the number of coordinates.}

\item{borders}{A \code{vector} of colors for drawing the borders.
Either a single value or of length exactly equals to the number of coordinates.}

\item{fac}{a factor within the $fac slot for colors}

\item{palette}{a color \link{palette}}

\item{coo_sample}{if not NULL the number of point per shape to display (to plot quickly)}

\item{names}{whether to plot names or not. If TRUE uses shape names, or something for \link{fac_dispatcher}}

\item{cex.names}{a cex for the names}

\item{points}{\code{logical} (for Ldk) whether to draw points}

\item{points.pch}{(for Ldk) and a pch for these points}

\item{points.cex}{(for Ldk) and a cex for these points}

\item{points.col}{(for Ldk) and a col  for these points}
}
\value{
a plot
}
\description{
Plots all the outlines, side by side, from
a \link{Coo} (\link{Out}, \link{Opn} or \link{Ldk}) objects.
}
\note{
If you want to reorder shapes according to a factor, use \link{arrange}.
}
\examples{
panel(mosquito, names=TRUE, cex.names=0.5)
panel(olea)
panel(bot, c(4, 10))
# an illustration of the use of fac
panel(bot, fac='type', palette=col_spring, names=TRUE)
}
\seealso{
Other Coo_graphics: 
\code{\link{inspect}()},
\code{\link{stack}()}
}
\concept{Coo_graphics}
