% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcNNindex.r
\name{mcNNindex}
\alias{mcNNindex}
\title{find nearest neighbours for 2D and 3D point clouds}
\usage{
mcNNindex(target, query, cores = parallel::detectCores(), k = k, ...)
}
\arguments{
\item{target}{\code{k x m} matrix containing data which to search.}

\item{query}{\code{l x m} matrix containing data for which to search.}

\item{cores}{integer: amount of CPU-cores to be used. Only available on systems with OpenMP support.}

\item{k}{integer: how many closest points are sought.}

\item{\dots}{additional arguments - currently unused.}
}
\value{
\code{l x k } matrix containing indices of closest points.
}
\description{
find nearest neighbours for point clouds using a kd-tree search. This is just a wrapper of the function vcgKDtree from
package Rvcg. Wwraps the function \code{vcgKDtree} from package 'Rvcg' (for backward compatibility )
}
\examples{

require(rgl)
data(nose)
# find closest vertex on surface for each landmark
clost <- mcNNindex(vert2points(shortnose.mesh),shortnose.lm, k=1,
mc.cores=1)
\dontrun{
spheres3d(vert2points(shortnose.mesh)[clost,],col=2,radius=0.3)
spheres3d(shortnose.lm,radius=0.3)
wire3d(shortnose.mesh)
}
}
\seealso{
\code{\link{closemeshKD}}
}
