% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilityFunctions.R
\name{mT.switchover}
\alias{mT.switchover}
\title{Switch over mortalities from one table to another at a given age}
\usage{
mT.switchover(table, to, at, weights = NULL)
}
\arguments{
\item{table}{The \code{mortalityTable} to modify (transition the probabilities to the secondary table)}

\item{to}{The secondary \code{mortalityTable} containing the target probabilities}

\item{at}{The age at which to switch over to the secondary table (if \code{weights} are given, the \code{at} argument is ignored).}

\item{weights}{(optional) transition weights for transitioning the probabilities from the primary to the secondary table (as a linear combination).}
}
\description{
This function modifies a \code{mortalityTable} by switching moralities at a given
age to the mortalities of a second table.
}
\details{
This function \code{mT.switchover} modifies the given \code{mortalityTable}
and replaces the mortalities starting from a given age by the mortalities
of a second table. By default, the transition from the original table to the
secondary table is a simple 0/1-switch at the given age \code{at}. This is done
internally by using \code{weights= (age >= at)}.

By giving custom weights, one can also implement a smooth transition to the
secondary table. The weights are used as simple factors of a linear combination
of the two tables.
}
\examples{
mortalityTables.load("Austria_Census")
mort.AT.switchover = mT.switchover(mort.AT.census.2011.male, mort.AT.census.2011.female, 60)
plotMortalityTables(mort.AT.census.2011.male,
                    mT.setName(mort.AT.switchover, "Switched to female at age 60"))

# A smooth switchover is possible with custom weights
mort.AT.switchover.smooth = mT.switchover(mort.AT.census.2011.male, mort.AT.census.2011.female,
    weights = c(rep(0, 55), 0:20/20, rep(1, 25)))
plotMortalityTables(mort.AT.census.2011.male,
    mT.setName(mort.AT.switchover.smooth, "Switched to female smoothly at ages 55-75"))

}
