% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mortalityTables.load.R
\name{mortalityTables.load}
\alias{mortalityTables.load}
\title{Load a named set of mortality tables provided by the \link{MortalityTables} package}
\usage{
mortalityTables.load(
  dataset,
  package = c("^MortalityTables", "^PensionTables"),
  prefix = "MortalityTables"
)
}
\arguments{
\item{dataset}{The set(s) of life tables to be loaded. A list of all available
data sets is provided by the function \code{\link{mortalityTables.list}}.
Wildcards (*) are allowed to match and load multiple datasets.}

\item{package}{The package that contains the dataset in its \code{extdata/}
directory. Defaults to all packages starting with names that
start with "MortalityTables" or "PensionTables".
Multiple packages can be given as a vector, even using regular expressions.
This package is not automatically loaded. If a provided
dataset needs its proving package loaded, it can do so explicitly.}

\item{prefix}{The prefix for the data sets (default is "MortalityTables").}
}
\description{
Load a named set of mortality tables provided by the \link{MortalityTables} package
}
\examples{
mortalityTables.list()
mortalityTables.load("Austria_Annuities_*")
mortalityTables.load("Austria_Annuities_AVOe2005R")
mortalityTables.load("*Annuities")
\dontrun{mortalityTables.load("MyCustomTable", package = c("MyCustomPackage"))}

}
