% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{read.tracks.csv}
\alias{read.tracks.csv}
\title{Read Tracks from Text File}
\usage{
read.tracks.csv(file, id.column = 1, time.column = 2, pos.columns = c(3,
  4, 5), scale.t = 1, scale.pos = 1, header = TRUE, sep = "",
  track.sep.blankline = FALSE, ...)
}
\arguments{
\item{file}{the name of the file which the data are to be read from, a 
readable text-mode connection or a complete URL
(see \code{\link[utils]{read.table}}).}

\item{id.column}{index or name of the column that contains the track ID.}

\item{time.column}{index or name of the column that contains elapsed time.}

\item{pos.columns}{vector containing indices or names of the columns that contain
the spatial coordinates. If this vector has two entries and the second entry is NA,
e.g. \code{c('x',NA)} or \code{c(5,NA)} then all columns from the indicated column 
to the last column are used. This is useful when reading files where the exact number
of spatial dimensions is not known beforehand.}

\item{scale.t}{a value by which to multiply each time point. Useful for changing units,
or for specifying the time between positions if this is not contained in the file
itself.}

\item{scale.pos}{a value, or a vector of values, by which to multiply each spatial 
position. Useful for changing units.}

\item{header}{a logical value indicating whether the file contains the
names of the variables as its first line. See \code{\link[utils]{read.table}}.}

\item{sep}{a character specifying how the colums of the data are separated. 
The default value \code{""} means columns are separated by tabs or other spaces.  
See \code{\link[utils]{read.table}}.}

\item{track.sep.blankline}{logical. If set to \code{TRUE}, then tracks are expected
to be separated by one or more blank lines in the input file instead of being 
designated by a track ID column. In this case, numerical track IDs are automatically
generated.}

\item{...}{further arguments to be passed to \code{read.csv}, for instance 
\code{sep="\t"} can be useful for tab-separated files.}
}
\value{
An object of class \emph{tracks} is returned, which is a list of 
matrices, each containing the positions of one track. The matrices 
have a column \eqn{t}, followed by one column for each of the input track's 
coordinates.
}
\description{
Reads cell tracks from a CSV or other text file. Data are expected to be organized as
follows.
One column contains a track identifier, which can be numeric or a string, and 
determines which points belong to the same track. 
Another column is expected to contain a time index or a time period (e.g. number of
seconds elapsed since the beginning of the track, or since the beginning of the 
experiment). Input of dates is not (yet) supported, as absolute time information is
frequently not available. 
One to three further columns contain the spatial coordinates 
(depending on whether the tracks are 1D, 2D or 3D). 
The names or indices of these columns in the CSV files are given using the 
corresponding parameters (see below). Names and indices can be mixed, e.g. you can
specify \code{id.column="Parent"} and \code{pos.columns=1:3}
}
\details{
The input file's first four fields are interpreted as \eqn{id}, 
\eqn{pos}, \eqn{t} and \eqn{x}, respectively, and, if available, the fifth
as \eqn{y} and the sixth as \eqn{z}. The returned object has the class 
\emph{tracks}, which is a list of data frames representing the single 
tracks and having columns \eqn{t} and \eqn{x}, plus \eqn{y} and \eqn{z}, if
necessary. The tracks' ids are retained in their position in the list, while
the field \eqn{pos} will be unmaintained.
}

