% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Qfit.R
\name{classify_features_ff}
\alias{classify_features_ff}
\title{Helper function factory to classify morphometric features}
\usage{
classify_features_ff(slope_tolerance = 1, curvature_tolerance = 1e-04)
}
\arguments{
\item{slope_tolerance}{Slope tolerance that defines a 'flat' surface (degrees; default is 1.0). Relevant for the features layer.}

\item{curvature_tolerance}{Curvature tolerance that defines 'planar' surface (default is 0.0001). Relevant for the features layer.}
}
\value{
A function that can be passed to raster::overlay to classify morphometric features
}
\description{
Helper function factory to classify morphometric features according to a modified version of Wood 1996 page 120
}
\references{
Wood, J., 1996. The geomorphological characterisation of digital elevation models (Ph.D.). University of Leicester.
}
